/* - GDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.GPSPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GDetachListener implements DetachListener {

    private JFrame appFrame;
    private JPanel gpsPanel;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JCheckBox fixStatusChk;
    private JTextField dateTxt;
    private JTextField timeTxt;
    private JTextField latTxt;
    private JTextField longTxt;
    private JTextField altTxt;
    private JTextField velTxt;
    private JTextField headTxt;

    public GDetachListener(JFrame appFrame, JPanel gpsPanel, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JCheckBox fixStatusChk, JTextField dateTxt,
            JTextField timeTxt, JTextField latTxt, JTextField longTxt, JTextField altTxt, JTextField velTxt,
            JTextField headTxt) {

        this.appFrame = appFrame;
        this.gpsPanel = gpsPanel;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;

        this.fixStatusChk = fixStatusChk;
        this.dateTxt = dateTxt;
        this.timeTxt = timeTxt;
        this.latTxt = latTxt;
        this.longTxt = longTxt;
        this.altTxt = altTxt;
        this.velTxt = velTxt;
        this.headTxt = headTxt;
    }

    public void detached(DetachEvent de) {
        try {
            GPSPhidget detached = (GPSPhidget) de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");

            fixStatusChk.setSelected(false);
            fixStatusChk.setEnabled(false);
            dateTxt.setText("");
            timeTxt.setText("");
            latTxt.setText("");
            longTxt.setText("");

            altTxt.setText("");
            velTxt.setText("");
            headTxt.setText("");

            gpsPanel.setVisible(false);

            appFrame.setSize(357, 265);

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
